/*:
 * @target MZ
 * @plugindesc [v1.0.1] Sanft schwebende Glühwürmchen ✨
 * @author Yui
 *
 * @command StartFireflies
 * @text Starte Glühwürmchen
 * @desc Löst den Glühwürmchen-Effekt aus
 *
 * @command StopFireflies
 * @text Stoppe Glühwürmchen
 * @desc Entfernt den Glühwürmchen-Effekt wieder
 */

(() => {
    const pluginName = "Firefly_Plugin";

    const fireflyCount = 15;
    const glowIntensity = 1.0;

    let fireflies = [];
    let fireflyContainer = null;
    let isActive = false;

    class Firefly {
        constructor() {
            this.x = Math.random() * Graphics.width;
            this.y = Math.random() * Graphics.height;
            this.vx = (Math.random() - 0.5) * 0.3; // deutlich langsamer
            this.vy = (Math.random() - 0.5) * 0.3;
            this.alpha = 0.3 + Math.random() * 0.7;
            this.size = 2 + Math.random() * 3;
            this.glowPhase = Math.random() * Math.PI * 2;
            this.glowSpeed = 0.02 + Math.random() * 0.03;

            this.canvas = document.createElement('canvas');
            this.canvas.width = 20;
            this.canvas.height = 20;
            this.ctx = this.canvas.getContext('2d');

            this.sprite = new Sprite();
            this.sprite.bitmap = new Bitmap(20, 20);

            this.updateGlow();
        }

        updateGlow() {
            this.ctx.clearRect(0, 0, 20, 20);
            const centerX = 10;
            const centerY = 10;
            const currentGlow = 0.5 + Math.sin(this.glowPhase) * 0.5;

            const outerGradient = this.ctx.createRadialGradient(centerX, centerY, 0, centerX, centerY, 8 * currentGlow);
            outerGradient.addColorStop(0, `rgba(255, 223, 100, ${0.3 * currentGlow * glowIntensity})`);
            outerGradient.addColorStop(0.5, `rgba(255, 200, 80, ${0.1 * currentGlow * glowIntensity})`);
            outerGradient.addColorStop(1, 'rgba(255, 180, 60, 0)');
            this.ctx.fillStyle = outerGradient;
            this.ctx.fillRect(0, 0, 20, 20);

            const innerGradient = this.ctx.createRadialGradient(centerX, centerY, 0, centerX, centerY, 4 * currentGlow);
            innerGradient.addColorStop(0, `rgba(255, 240, 150, ${0.8 * currentGlow * glowIntensity})`);
            innerGradient.addColorStop(0.7, `rgba(255, 220, 120, ${0.4 * currentGlow * glowIntensity})`);
            innerGradient.addColorStop(1, 'rgba(255, 200, 100, 0)');
            this.ctx.fillStyle = innerGradient;
            this.ctx.fillRect(0, 0, 20, 20);

            const coreGradient = this.ctx.createRadialGradient(centerX, centerY, 0, centerX, centerY, this.size * currentGlow);
            coreGradient.addColorStop(0, `rgba(255, 255, 200, ${currentGlow * glowIntensity})`);
            coreGradient.addColorStop(1, 'rgba(255, 230, 150, 0)');
            this.ctx.fillStyle = coreGradient;
            this.ctx.fillRect(0, 0, 20, 20);

            this.sprite.bitmap.clear();
            const imageData = this.ctx.getImageData(0, 0, 20, 20);
            this.sprite.bitmap._context.putImageData(imageData, 0, 0);
        }

        update() {
            this.x += this.vx;
            this.y += this.vy;
            this.vx += (Math.random() - 0.5) * 0.02;
            this.vy += (Math.random() - 0.5) * 0.02;
            this.vx = Math.max(-0.4, Math.min(0.4, this.vx));
            this.vy = Math.max(-0.4, Math.min(0.4, this.vy));

            if (this.x < -10) this.x = Graphics.width + 10;
            if (this.x > Graphics.width + 10) this.x = -10;
            if (this.y < -10) this.y = Graphics.height + 10;
            if (this.y > Graphics.height + 10) this.y = -10;

            this.glowPhase += this.glowSpeed;
            if (Math.random() < 0.02) {
                this.updateGlow();
            }

            this.sprite.x = this.x - 10;
            this.sprite.y = this.y - 10;
        }
    }

    function startFireflies() {
        if (isActive) return;
        isActive = true;
        fireflies = [];
        fireflyContainer = new Sprite();
        SceneManager._scene.addChild(fireflyContainer);

        for (let i = 0; i < fireflyCount; i++) {
            const firefly = new Firefly();
            fireflies.push(firefly);
            fireflyContainer.addChild(firefly.sprite);
        }
    }

    function stopFireflies() {
        if (!isActive) return;
        isActive = false;
        if (fireflyContainer && fireflyContainer.parent) {
            fireflyContainer.parent.removeChild(fireflyContainer);
        }
        fireflies = [];
        fireflyContainer = null;
    }

    const _Scene_Map_update = Scene_Map.prototype.update;
    Scene_Map.prototype.update = function () {
        _Scene_Map_update.call(this);
        if (isActive && fireflies.length > 0) {
            fireflies.forEach(firefly => firefly.update());
        }
    };

    const _Scene_Map_terminate = Scene_Map.prototype.terminate;
    Scene_Map.prototype.terminate = function () {
        stopFireflies();
        _Scene_Map_terminate.call(this);
    };

    PluginManager.registerCommand(pluginName, "StartFireflies", () => {
        startFireflies();
    });

    PluginManager.registerCommand(pluginName, "StopFireflies", () => {
        stopFireflies();
    });

})();
